/*
 * Decompiled with CFR 0.152.
 */
package tech.feldman.betterrecords.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.feldman.betterrecords.BetterRecords;
import tech.feldman.betterrecords.ModConfig;
import tech.feldman.betterrecords.util.DownloadUtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001ap\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u000528\b\u0002\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00010\u00072\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e\u00a8\u0006\u0010"}, d2={"downloadFile", "", "url", "Ljava/net/URL;", "target", "Ljava/io/File;", "update", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "curr", "total", "success", "Lkotlin/Function0;", "failure", "BetterRecords"})
public final class DownloadUtilKt {
    public static final void downloadFile(@NotNull URL url, @NotNull File target, @NotNull Function2<? super Float, ? super Float, Unit> update, @NotNull Function0<Unit> success, @NotNull Function0<Unit> failure) {
        URLConnection connection;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull(update, (String)"update");
        Intrinsics.checkParameterIsNotNull(success, (String)"success");
        Intrinsics.checkParameterIsNotNull(failure, (String)"failure");
        URLConnection uRLConnection = connection = url.openConnection();
        Intrinsics.checkExpressionValueIsNotNull((Object)uRLConnection, (String)"connection");
        long size = uRLConnection.getContentLength();
        if (size == target.length()) {
            BetterRecords.INSTANCE.getLogger().info("Target file exists in cache");
            success.invoke();
            return;
        }
        if (size / (long)1024 / (long)1024 > (long)ModConfig.client.downloadMax) {
            failure.invoke();
            return;
        }
        target.delete();
        target.getParentFile().mkdirs();
        BufferedInputStream inputStream = new BufferedInputStream(url.openStream());
        FileOutputStream outputStream = new FileOutputStream(target);
        long bytesCopied = 0L;
        byte[] buffer = new byte[1024];
        int bytes = inputStream.read(buffer);
        while (bytes >= 0) {
            outputStream.write(buffer, 0, bytes);
            update.invoke((Object)Float.valueOf(bytesCopied += (long)bytes), (Object)Float.valueOf(size));
            bytes = inputStream.read(buffer);
        }
        inputStream.close();
        outputStream.close();
        success.invoke();
    }

    public static /* synthetic */ void downloadFile$default(URL uRL, File file, Function2 function2, Function0 function0, Function0 function02, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = downloadFile.1.INSTANCE;
        }
        if ((n & 8) != 0) {
            function0 = downloadFile.2.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function02 = downloadFile.3.INSTANCE;
        }
        DownloadUtilKt.downloadFile(uRL, file, (Function2<? super Float, ? super Float, Unit>)function2, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }
}

